import { localhostdomain, WorkDomain } from "../domain";
import { notFound } from "next/navigation";
import dynamic from "next/dynamic";
import { headers } from "next/headers";
import { FetchData } from "@/libs/api";
const ContentSec = dynamic(() => import("@/sections/ContentSec"));
const WebsiteSchema = dynamic(() =>
  import("@/components/Schema/WebsiteSchema")
);
const RatingSchema = dynamic(() => import("@/components/Schema/RatingSchema"));
export async function generateMetadata({ params }) {
  const { why_page } = params;
  const requestHeaders = headers();
  const host = requestHeaders.get("host") || "";
  const isLocalhost = host.includes(localhostdomain);
  const domain = isLocalhost ? WorkDomain : host;
  const first_para = "why_invest";
  const data = await FetchData(domain, first_para);
  const { meta_title, meta_desc, meta_keywords, slug } = data ?? {};
  return {
    metadataBase: new URL(`https://${domain}/${slug}`),
    title: meta_title,
    description: meta_desc,
    keywords: meta_keywords,
    alternates: {
      canonical: why_page,
    },
    openGraph: {
      url: "/",
    },
  };
}
export default async function page({ params }) {
  const { why_page } = params;
  const requestHeaders = headers();
  const host = requestHeaders.get("host") || "";
  const isLocalhost = host.includes(localhostdomain);
  const domain = isLocalhost ? WorkDomain : host;
  const first_para = "why_invest";
  const data = await FetchData(domain, first_para);
  if (!data) {
    notFound();
  }
  const { title, content, meta_title, meta_desc, meta_keywords, slug } =
    data ?? {};
  if (why_page !== slug) {
    notFound();
  }
  return (
    <>
      <WebsiteSchema
        title={meta_title}
        description={meta_desc}
        keywords={meta_keywords}
        fullUrl={`https://${domain}/${slug}`}
      />
      <RatingSchema title={meta_title} />
      <div className="container mt-5">
        <h1>{title}</h1>
      </div>
      <ContentSec content={content} classCus="mt-0" />
    </>
  );
}
